<?php

/**
 * Class that operate on table 'm_insurance'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-09-28 10:16
 */
class MInsuranceMySqlDAO implements MInsuranceDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return MInsuranceMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM m_insurance WHERE insuranceId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM m_insurance';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM m_insurance ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param mInsurance primary key
     */
    public function delete($insuranceId) {
        $sql = 'DELETE FROM m_insurance WHERE insuranceId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($insuranceId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param MInsuranceMySql mInsurance
     */
    public function insert($mInsurance) {
        $sql = 'INSERT INTO m_insurance (ourSerial, stageIdBefore, currentStage, shipNameGo, shipCompanyGo, shipPersonalGo, shipCostGo, shipNameReturned, shipCompanyReturned, shipPersonalReturned, shipCostReturned, type, oldSN, newSN, insuranceCost, kindOfInsurance, insuranceDate, insuranceDiscount, userId, branchId, comment, del, returned) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($mInsurance->ourSerial);
        $sqlQuery->setNumber($mInsurance->stageIdBefore);
        $sqlQuery->setNumber($mInsurance->currentStage);
        $sqlQuery->setNumber($mInsurance->shipNameGo);
        $sqlQuery->setNumber($mInsurance->shipCompanyGo);
        $sqlQuery->setNumber($mInsurance->shipPersonalGo);
        $sqlQuery->set($mInsurance->shipCostGo);
        $sqlQuery->setNumber($mInsurance->shipNameReturned);
        $sqlQuery->setNumber($mInsurance->shipCompanyReturned);
        $sqlQuery->setNumber($mInsurance->shipPersonalReturned);
        $sqlQuery->set($mInsurance->shipCostReturned);
        $sqlQuery->setNumber($mInsurance->type);
        $sqlQuery->set($mInsurance->oldSN);
        $sqlQuery->set($mInsurance->newSN);
        $sqlQuery->set($mInsurance->insuranceCost);
        $sqlQuery->setNumber($mInsurance->kindOfInsurance);
        $sqlQuery->set($mInsurance->insuranceDate);
        $sqlQuery->set($mInsurance->insuranceDiscount);
        $sqlQuery->setNumber($mInsurance->userId);
        $sqlQuery->setNumber($mInsurance->branchId);
        $sqlQuery->setString2($mInsurance->comment);
        $sqlQuery->setNumber($mInsurance->del);
        $sqlQuery->setNumber($mInsurance->returned);

        $id = $this->executeInsert($sqlQuery);
        $mInsurance->insuranceId = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param MInsuranceMySql mInsurance
     */
    public function update($mInsurance) {
        $sql = 'UPDATE m_insurance SET ourSerial = ?, stageIdBefore = ?, currentStage = ?, shipNameGo = ?, shipCompanyGo = ?, shipPersonalGo = ?, shipCostGo = ?, shipNameReturned = ?, shipCompanyReturned = ?, shipPersonalReturned = ?, shipCostReturned = ?, type = ?, oldSN = ?, newSN = ?, insuranceCost = ?, kindOfInsurance = ?, insuranceDate = ?, insuranceDiscount = ?, userId = ?, branchId = ?, comment = ?, del = ?, returned = ? WHERE insuranceId = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($mInsurance->ourSerial);
        $sqlQuery->setNumber($mInsurance->stageIdBefore);
        $sqlQuery->setNumber($mInsurance->currentStage);
        $sqlQuery->setNumber($mInsurance->shipNameGo);
        $sqlQuery->setNumber($mInsurance->shipCompanyGo);
        $sqlQuery->setNumber($mInsurance->shipPersonalGo);
        $sqlQuery->set($mInsurance->shipCostGo);
        $sqlQuery->setNumber($mInsurance->shipNameReturned);
        $sqlQuery->setNumber($mInsurance->shipCompanyReturned);
        $sqlQuery->setNumber($mInsurance->shipPersonalReturned);
        $sqlQuery->set($mInsurance->shipCostReturned);
        $sqlQuery->setNumber($mInsurance->type);
        $sqlQuery->set($mInsurance->oldSN);
        $sqlQuery->set($mInsurance->newSN);
        $sqlQuery->set($mInsurance->insuranceCost);
        $sqlQuery->setNumber($mInsurance->kindOfInsurance);
        $sqlQuery->set($mInsurance->insuranceDate);
        $sqlQuery->set($mInsurance->insuranceDiscount);
        $sqlQuery->setNumber($mInsurance->userId);
        $sqlQuery->setNumber($mInsurance->branchId);
        $sqlQuery->setString2($mInsurance->comment);
        $sqlQuery->setNumber($mInsurance->del);
        $sqlQuery->setNumber($mInsurance->returned);

        $sqlQuery->setNumber($mInsurance->insuranceId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM m_insurance';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByOurSerial($value) {
        $sql = 'SELECT * FROM m_insurance WHERE ourSerial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStageIdBefore($value) {
        $sql = 'SELECT * FROM m_insurance WHERE stageIdBefore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCurrentStage($value) {
        $sql = 'SELECT * FROM m_insurance WHERE currentStage = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByShipNameGo($value) {
        $sql = 'SELECT * FROM m_insurance WHERE shipNameGo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByShipCompanyGo($value) {
        $sql = 'SELECT * FROM m_insurance WHERE shipCompanyGo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByShipPersonalGo($value) {
        $sql = 'SELECT * FROM m_insurance WHERE shipPersonalGo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByShipCostGo($value) {
        $sql = 'SELECT * FROM m_insurance WHERE shipCostGo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByShipNameReturned($value) {
        $sql = 'SELECT * FROM m_insurance WHERE shipNameReturned = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByShipCompanyReturned($value) {
        $sql = 'SELECT * FROM m_insurance WHERE shipCompanyReturned = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByShipPersonalReturned($value) {
        $sql = 'SELECT * FROM m_insurance WHERE shipPersonalReturned = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByShipCostReturned($value) {
        $sql = 'SELECT * FROM m_insurance WHERE shipCostReturned = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByType($value) {
        $sql = 'SELECT * FROM m_insurance WHERE type = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOldSN($value) {
        $sql = 'SELECT * FROM m_insurance WHERE oldSN = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNewSN($value) {
        $sql = 'SELECT * FROM m_insurance WHERE newSN = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByInsuranceCost($value) {
        $sql = 'SELECT * FROM m_insurance WHERE insuranceCost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByKindOfInsurance($value) {
        $sql = 'SELECT * FROM m_insurance WHERE kindOfInsurance = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByInsuranceDate($value) {
        $sql = 'SELECT * FROM m_insurance WHERE insuranceDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByInsuranceDiscount($value) {
        $sql = 'SELECT * FROM m_insurance WHERE insuranceDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserId($value) {
        $sql = 'SELECT * FROM m_insurance WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBranchId($value) {
        $sql = 'SELECT * FROM m_insurance WHERE branchId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByComment($value) {
        $sql = 'SELECT * FROM m_insurance WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM m_insurance WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturned($value) {
        $sql = 'SELECT * FROM m_insurance WHERE returned = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByOurSerial($value) {
        $sql = 'DELETE FROM m_insurance WHERE ourSerial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStageIdBefore($value) {
        $sql = 'DELETE FROM m_insurance WHERE stageIdBefore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCurrentStage($value) {
        $sql = 'DELETE FROM m_insurance WHERE currentStage = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByShipNameGo($value) {
        $sql = 'DELETE FROM m_insurance WHERE shipNameGo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByShipCompanyGo($value) {
        $sql = 'DELETE FROM m_insurance WHERE shipCompanyGo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByShipPersonalGo($value) {
        $sql = 'DELETE FROM m_insurance WHERE shipPersonalGo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByShipCostGo($value) {
        $sql = 'DELETE FROM m_insurance WHERE shipCostGo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByShipNameReturned($value) {
        $sql = 'DELETE FROM m_insurance WHERE shipNameReturned = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByShipCompanyReturned($value) {
        $sql = 'DELETE FROM m_insurance WHERE shipCompanyReturned = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByShipPersonalReturned($value) {
        $sql = 'DELETE FROM m_insurance WHERE shipPersonalReturned = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByShipCostReturned($value) {
        $sql = 'DELETE FROM m_insurance WHERE shipCostReturned = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByType($value) {
        $sql = 'DELETE FROM m_insurance WHERE type = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOldSN($value) {
        $sql = 'DELETE FROM m_insurance WHERE oldSN = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNewSN($value) {
        $sql = 'DELETE FROM m_insurance WHERE newSN = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByInsuranceCost($value) {
        $sql = 'DELETE FROM m_insurance WHERE insuranceCost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByKindOfInsurance($value) {
        $sql = 'DELETE FROM m_insurance WHERE kindOfInsurance = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByInsuranceDate($value) {
        $sql = 'DELETE FROM m_insurance WHERE insuranceDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByInsuranceDiscount($value) {
        $sql = 'DELETE FROM m_insurance WHERE insuranceDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserId($value) {
        $sql = 'DELETE FROM m_insurance WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBranchId($value) {
        $sql = 'DELETE FROM m_insurance WHERE branchId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByComment($value) {
        $sql = 'DELETE FROM m_insurance WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM m_insurance WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturned($value) {
        $sql = 'DELETE FROM m_insurance WHERE returned = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return MInsuranceMySql
     */
    protected function readRow($row) {
        $mInsurance = new MInsurance();

        $mInsurance->insuranceId = isset($row['insuranceId']) ? $row['insuranceId'] : '';
        $mInsurance->ourSerial = isset($row['ourSerial']) ? $row['ourSerial'] : '';
        $mInsurance->stageIdBefore = isset($row['stageIdBefore']) ? $row['stageIdBefore'] : '';
        $mInsurance->currentStage = isset($row['currentStage']) ? $row['currentStage'] : '';
        $mInsurance->shipNameGo = isset($row['shipNameGo']) ? $row['shipNameGo'] : '';
        $mInsurance->shipCompanyGo = isset($row['shipCompanyGo']) ? $row['shipCompanyGo'] : '';
        $mInsurance->shipPersonalGo = isset($row['shipPersonalGo']) ? $row['shipPersonalGo'] : '';
        $mInsurance->shipCostGo = isset($row['shipCostGo']) ? $row['shipCostGo'] : '';
        $mInsurance->shipNameReturned = isset($row['shipNameReturned']) ? $row['shipNameReturned'] : '';
        $mInsurance->shipCompanyReturned = isset($row['shipCompanyReturned']) ? $row['shipCompanyReturned'] : '';
        $mInsurance->shipPersonalReturned = isset($row['shipPersonalReturned']) ? $row['shipPersonalReturned'] : '';
        $mInsurance->shipCostReturned = isset($row['shipCostReturned']) ? $row['shipCostReturned'] : '';
        $mInsurance->type = isset($row['type']) ? $row['type'] : '';
        $mInsurance->oldSN = isset($row['oldSN']) ? $row['oldSN'] : '';
        $mInsurance->newSN = isset($row['newSN']) ? $row['newSN'] : '';
        $mInsurance->insuranceCost = isset($row['insuranceCost']) ? $row['insuranceCost'] : '';
        $mInsurance->kindOfInsurance = isset($row['kindOfInsurance']) ? $row['kindOfInsurance'] : '';
        $mInsurance->insuranceDate = isset($row['insuranceDate']) ? $row['insuranceDate'] : '';
        $mInsurance->insuranceDiscount = isset($row['insuranceDiscount']) ? $row['insuranceDiscount'] : '';
        $mInsurance->userId = isset($row['userId']) ? $row['userId'] : '';
        $mInsurance->branchId = isset($row['branchId']) ? $row['branchId'] : '';
        $mInsurance->comment = isset($row['comment']) ? $row['comment'] : '';
        $mInsurance->del = isset($row['del']) ? $row['del'] : '';
        $mInsurance->returned = isset($row['returned']) ? $row['returned'] : '';

        return $mInsurance;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return MInsuranceMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>